jQuery(document).ready(function () {

    if (jQuery(window).width() < 768) {
        jQuery('#nav-icon').click(function () {
            jQuery(this).toggleClass('open');
            jQuery('#block-main-menu ul').slideToggle(200);
        });
        jQuery('#block-main-menu ul li a').click(function () {
            jQuery('#block-main-menu ul').slideUp(200);
            jQuery('#nav-icon').removeClass('open');
        });
    }

    jQuery('.realizations .horizontal-slider').slick({
        slidesToShow: 1,
        slidesToScroll: 1,
        centerMode: true,
        variableWidth: true,
        infinite: true,
        appendArrows: jQuery('.realizations .slick-arrows'),
        prevArrow: jQuery('.realizations .slick-arrow.prev'),
        nextArrow: jQuery('.realizations .slick-arrow.next'),

    });

    jQuery('.faq .item').click(function () {
        if(jQuery(this).hasClass('active')) {
            jQuery('.faq .item.active .answer').slideUp(300);
            jQuery('.faq .item').removeClass('active');
        } else {
            jQuery('.faq .item.active .answer').slideUp(300);
            jQuery('.faq .item').removeClass('active');
            jQuery(this).addClass('active').children('.answer').slideDown(300);
        }
    });

    jQuery('.offer .offer-box').click(function () {
        jQuery('.offer .offer-box.active').removeClass('active');
        jQuery(this).addClass('active');
        var text = jQuery(this).data('description');
        jQuery('.offer .content .text p').html(text);
    });

    jQuery(window).scroll(function () {
        var fromTop = jQuery(document).scrollTop(),
            oferta = jQuery('div[data-id="oferta"]').offset().top,
            realizacje = jQuery('div[data-id="realizacje"]').offset().top,
            faq = jQuery('div[data-id="faq"]').offset().top,
            ofirmie = jQuery('div[data-id="o-firmie"]').offset().top,
            kontakt = jQuery('div[data-id="kontakt"]').offset().top;

        if (fromTop > 200) {
            jQuery('header').addClass('scroll');
        } else {
            jQuery('header').removeClass('scroll');
        }

        if (fromTop > oferta - 134 && fromTop < realizacje - 120)
            jQuery('#block-main-menu li:first-child').addClass('now');
        else
            jQuery('#block-main-menu li:first-child').removeClass('now');

        if (fromTop > realizacje - 120 && fromTop < faq - 120)
            jQuery('#block-main-menu li:nth-child(2)').addClass('now');
        else
            jQuery('#block-main-menu li:nth-child(2)').removeClass('now');

        if (fromTop > faq - 120 && fromTop < ofirmie - 101)
            jQuery('#block-main-menu li:nth-child(3)').addClass('now');
        else
            jQuery('#block-main-menu li:nth-child(3)').removeClass('now');

        if (fromTop > ofirmie - 120 && fromTop < kontakt - 120)
            jQuery('#block-main-menu li:nth-child(4)').addClass('now');
        else
            jQuery('#block-main-menu li:nth-child(4)').removeClass('now');

        if (fromTop > kontakt - 120)
            jQuery('#block-main-menu li:nth-child(5)').addClass('now');
        else
            jQuery('#block-main-menu li:nth-child(5)').removeClass('now');
    });

    jQuery('#block-main-menu a[href*="#"]').click(function () {
        if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
            var $target = jQuery(this.hash);
            $target = $target.length && $target || jQuery('[data-id=' + this.hash.slice(1) + ']');
            if ($target.length) {
                var targetOffset = $target.offset().top - 100;
                jQuery('html,body')
                    .animate({scrollTop: targetOffset}, 1000);
                return false;
            }
        }
    });

    if (jQuery(window).width() < 768 && jQuery(window).width() > 575) {
        jQuery('.offer .offer-box').click(function () {
            var target = jQuery('.offer .content.desktop').offset().top - 300;
            jQuery('html, body').animate({scrollTop: target}, 1000);
        });
    }

    AOS.init({
        duration: 500,
        delay: 100
    });
});